from ftplib import FTP
import filecmp
import os
import shutil

class Logs():

	serverFtp = 'logs.beamian.com'
	userFtp = 'logs@beamian.com'
	passwordFtp = "KG^Hn5B0RqBq+?I=F}"

	currentLogFile = 'data/log.csv'
	tempLogFile = 'data/log.temp_csv'
	backupLogFile = 'data/log.backup_csv'
	serverPath = 'logs/'

	def __init__(self, deviceId):
		#Create file in server with format eg B2001.txt
		self.deviceId = deviceId

		self.numberLogs = 0

		if os.path.isfile(self.currentLogFile):
			self.numberLogs = sum(1 for line in open(self.currentLogFile))

		print('Logs in file: ' + str(self.numberLogs))

	def numberLogsInFile(self):
		return self.numberLogs

	def getCurrentLogCount(self):
		#if os.path.isfile(self.currentLogFile):
		#	self.numberLogs = sum(1 for line in open(self.currentLogFile))
		print "log count: ", self.numberLogsInFile()

	def clearLogs(self):
		try:
			if os.path.isfile(self.currentLogFile):
				os.remove(self.currentLogFile)
			if os.path.isfile(self.tempLogFile):
				os.remove(self.tempLogFile)
			self.numberLogs = 0
		except Exception as e:
			pass

	def sendLog(self, delete=True):

		if not os.path.isfile(self.currentLogFile):
			return True, 'No log file to upload'

		local_path  = self.currentLogFile
		try:

			ftp = FTP(self.serverFtp)
			ftp.login(self.userFtp, self.passwordFtp)

			ftpFiles = ftp.nlst(self.serverPath)

			fileName  = self.deviceId + '.csv'
			for i in range (0, 999):
				if fileName in ftpFiles:
					fileName = self.deviceId + "_" + str(i).zfill(3) + '.csv'
					continue
				else:
					break

			if i > 999:
				return False, 'Old log files in server'

			server_path = self.serverPath + fileName

			print('File Name Server' + fileName)


			f = open(local_path, 'rb')
			ftp.storbinary('STOR ' + server_path, f)
			f.close()

			ftp.quit()

			r, m = self.checkLog(server_path)
			if r and delete:
				os.remove(self.currentLogFile)
				self.numberLogs = 0

			return r, m


		except Exception as e:
			errorMsg = str(e)
			return False, errorMsg[errorMsg.find("]") + 1:]

	def checkLog(self, server_path):
		local_path  = '/tmp/beamian_log'

		try:
			ftp = FTP(self.serverFtp)
			ftp.login(self.userFtp, self.passwordFtp)

			f = open(local_path, 'wb')
			ftp.retrbinary('RETR ' + server_path, f.write)
			f.close()

			ftp.quit()

			if filecmp.cmp(local_path,self.currentLogFile):
				return True, 'Log file uploaded with success'

			return False, 'Local log file do not match with server'

		except Exception as e:
			errorMsg = str(e)
			return False, errorMsg[errorMsg.find("]") + 1:]

	def copyLog(self):
		state = 0
		if os.path.isfile(self.tempLogFile):
			os.remove(self.tempLogFile)
			state+=1
		if os.path.isfile(self.currentLogFile):
			shutil.copy(self.currentLogFile, self.tempLogFile)
			state+=1
		return state

	def writeLine(self, tag, timeStr , devID, typeStr):

		#tag, id, type are strings
		#timeStr is in format %Y-%m-%d %H:%M:%S
		if os.path.isfile(self.currentLogFile):
			print "log.csv size: ", os.path.getsize(self.currentLogFile)
		#save in csv format
		row = ",".join([tag,timeStr, devID, typeStr])
		#CSV format
		#with open(self.currentLogFile,'a') as f:
		#	f.write(row + '\n')
		writeOK = False
		writeAttempts = 0
		while(not writeOK):
			self.copyLog()
			self.tryWriteFile(self.tempLogFile,row)
			writeAttempts+=1
			writeOK = self.checkFile(self.tempLogFile, tag, timeStr , devID, typeStr)
			if(writeAttempts>4):
				raise LogsFileError('log write file error')
				break
		if(writeOK):
			print "write OK"
			if os.path.isfile(self.backupLogFile):
				os.remove(self.backupLogFile)
			if os.path.isfile(self.currentLogFile):
				pre, ext = os.path.splitext(self.currentLogFile)
				os.rename(self.currentLogFile, pre + ".backup_csv")
			pre, ext = os.path.splitext(self.tempLogFile)
			os.rename(self.tempLogFile, pre + ".csv")
			


	def tryWriteFile(self,fileToWrite, formattedRow):
		# Write info to file
		if(fileToWrite.endswith(".temp_csv")):
			with open(fileToWrite, 'a') as f:
				f.write(formattedRow + '\n')
				f.close()
				return

	def seekToLastLine(self,fileToSeek):
		with open(fileToSeek, "r") as f: 
			lines = f.readlines()
			last = lines[-1]
			return last
	# def seekToLastLine(self, fileToSeek):
	# 	with open(fileToSeek, "r") as f: 
	# 		first = f.readline() 
	# 		print "seekline first line: " + first
	# 		val = f.read(1)
	# 		if val == None or val == '':
	# 			f.close()
	# 			return first 
	# 		print "jump to second last byte"
	# 		f.seek(-2, 2) 
	# 		print "jumped"
	# 		# Jump to the second last byte. 
	# 		while True:
	# 			value = f.read(1)
	# 			print "value: " + value
	# 			if value == b"\n":
	# 				break
	# 			# Until EOL is found...
	# 			f.seek(-2, 2) 
	# 			# ...jump back the read byte plus one more.
	# 		last = f.readline() 
	# 		print "seekline last line: " + last
	# 		# Read last line. 
	# 		f.close()
	# 		return last

	def checkFile(self,fileToCheck, tag, date, id, tagType):
		try:
			if not os.path.exists(fileToCheck):
				print "checkfile file does not exist, ", fileToCheck
				return False	
			if(not fileToCheck.endswith(".temp_csv")):
				return False

			if(os.path.getsize(fileToCheck) == 0):
				print "checkfile file has 0 bytes, ", fileToCheck
				return False 

			line = self.seekToLastLine(fileToCheck)

			if line is None:
				print "checkfile line is None, ", fileToCheck
				return False
			if line is '':
				print "checkfile line is Empty, ", fileToCheck
				return False
			# with open(fileToCheck, "rb") as f:
			# 	#first = f.readline()        # Read the first line.
			# 	
			# 	f.seek(-1, os.SEEK_END)     # Jump to the second last byte.
			# 	print "fseek"
			# 	while f.read(1) != b"\n":   # Until EOL is found...
			# 		print "fseek,while ! EOL"
			# 		f.seek(-2, os.SEEK_CUR) # ...jump back the read byte plus one more.
			# 	last = f.readline()         # Read last line.
			# 	print "checkfile last line: " + last
			# 	f.close()
			# with open(fileToCheck, 'rb') as f:
			# 	first = next(f).decode()
			# 	#seek back 200 chars relative to end of file 
			# 	f.seek(-200, os.SEEK_END)
			# 	#readlines all the lines after cursor
			# 	#select -1 (last entry in the array of lines)
			# 	last = f.readlines()[-1].decode()
			# 	print "checkfile last line: " + last
			# 	f.close()
			if(self.checkLine(line, tag, date, id, tagType)):
				return True
			else:
				return False
		except Exception as e:
			print 'Logs checkFile Exception' 
			print e
			return False
	
	def checkLine(self,lineToCheck, tag, date, id, tagType):
			sline = lineToCheck.rstrip()
			value_list = sline.split(",")
			
			if(len(value_list) is not 4):
				return False
			#tag 
			if(value_list[0] != tag):
				return False
			#date
			if(value_list[1] != date):
				return False
			
			if(not value_list[3].isalpha()):
				return False

			return True
