import fcntl, socket, struct
import requests


DOMAIN = 'https://a.beamian.com/'
WLAN_IF_NAME = 'wlan0'


def get_mac_address(if_name):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    info = fcntl.ioctl(s.fileno(), 0x8927,  struct.pack('256s', if_name[:15]))
    return ':'.join(['%02x' % ord(char) for char in info[18:24]])


class LiveInteraction:
    @staticmethod
    def get_mac_address():
        # get mac address and format it to something like AA:BB:CC::DD:EE
        mac = get_mac_address(WLAN_IF_NAME)
        with open("j_log.txt", "a") as fp:
            fp.write(mac)

        return mac

    def __init__(self):
        self.domain = DOMAIN
        self.endpoint = 'api/live-interactions'
        self.mac_address = self.get_mac_address()

    @property
    def url(self):
        return self.domain + self.endpoint

    def create(self, tag_id):
        data = {
            'mac_address': self.mac_address,
            'tag_id': tag_id
        }

        response = requests.post(self.url, json=data)

        if response.status_code == 201:
            # valid post - created new interaction
            return True
        if response.status_code == 200:
            # valid post - update interaction timestap
            return True

        return False

