import fcntl, socket, struct
import requests
import json


DOMAIN = 'https://a.beamian.com/'
WLAN_IF_NAME = 'wlan0'

class LiveInteraction:
    def __init__(self, MAC_address):
        self.domain = DOMAIN
        self.endpoint = 'api/live-interactions'
        self.MAC_address = MAC_address

    @property
    def url(self):
        return self.domain + self.endpoint

    def create(self, tag_id):
        data = {
            'mac_address': self.MAC_address,
            'tag_id': tag_id
        }

        response = requests.post(self.url, json=data)

        if response.status_code == 201:
            # valid post - created new interaction
            print 'new interaction'
            return True
        if response.status_code == 200:
            # valid post - update interaction timestap
            print 'update interaction timestamp'
            return True

        print 'failed, response_status: ', response.status_code

        return False

#def main():
#    print 'Live interaction TEST'
#    tag = '04EEE292B92980'
#
#    li = LiveInteraction()
#    li.create(tag)
                
#if __name__ == '__main__':
#        main()