import fcntl, socket, struct
import requests
import os
import csv


def get_mac_address(if_name):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    info = fcntl.ioctl(s.fileno(), 0x8927,  struct.pack('256s', if_name[:15]))
    return ':'.join(['%02x' % ord(char) for char in info[18:24]])


class Live:

    @staticmethod
    def get_mac_address():
        # get mac address and format it to something like AA:BB:CC::DD:EE
        mac = get_mac_address('wlan0')
        return mac


    def __init__(self):
        self.domain = 'https://api.beamian.com/'
        self.endpoint = 'api/live-interactions'
        self.mac_address = self.get_mac_address()

        # Read last tag and mode (standard,etc) from log file
        self.lastTag = None  # '04528A22A44080'  # testing only
        self.mode = None  # 'standard' # testing only



    @property
    def url(self):
        return self.domain + self.endpoint

    def sendLast(self):

        # test if there is any valid log line to send and load it
        currentLogFile = 'data/log.csv'
        interactions_sent_file = 'data/interactions_sent.txt'

        try:
            # import log list
            with open(currentLogFile) as logfile:
                lines = csv.reader(logfile, delimiter=',')
                data = [r for r in lines]
                rows = list(lines)
                totalrows = len(rows)
                last_row = data[totalrows-1]

        except Exception, e:
            print('Error loading log csv: ' + str(e))
            return False, 'Error loading log csv'

        # Read last sent interaction index
        try:
            with open(interactions_sent_file, "r") as f:
                last_sent_idx = int(f.readlines()[-1])
        except Exception, e:
            print("Error loading interactions index file: ", str(e))
            last_sent_idx = 0

        for i, interaction in enumerate(data[last_sent_idx:len(data)]):
            try:
                self.lastTag = interaction[0]
                self.mode = interaction[3]
            except IndexError, e:
                print('Error accessing last tag or mode: ', str(e))
                continue

            print(self.lastTag)
            print(self.mode)
            interaction_payload = {
                'mac_address': self.mac_address,
                'tag_id': self.lastTag,
                'mode': self.mode
            }
            print ('posting ')
            print (interaction_payload)
            print (' to url ' + self.url)

            try:
                response = requests.post(self.url, json=interaction_payload)
                print ('response')
                print response

                ret = None
                if response.status_code == 201 or response.status_code == 200:
                    # Save last sent interaction index to file
                    with open(interactions_sent_file, "a") as f:
                        current_sent_idx = i + last_sent_idx
                        f.write(str(current_sent_idx) + "\n")

                if response.status_code == 201:
                    # valid post - created new interaction
                    print ('valid post created new interaction')
                    ret = True, 'Sent to server'
                if response.status_code == 200:
                    # valid post - update interaction timestap
                    print ('valid post - update interaction timestamp')
                    ret = True, 'Already in server'

                if not ret:
                    print ('invalid post - some error')
                    # return False, 'Saved in device'

            except Exception, e:
                errorMsg = str(e)
                return False, errorMsg[errorMsg.find("]") + 1:]

        return True, 'Interactions sent to server'
