import sys
from ftplib import FTP
import csv
import os, subprocess
from time import sleep

class Wifi():

	currentConfig = "data/wifi.txt"
	currentIP = ".ip.txt"
	
	ssid=""
	password=""
	ip=""
	
	def __init__(self, keepOldConfig = False):
		if not keepOldConfig:
			try:
				os.remove(self.currentIP)
			except OSError:
				pass
			
		s, p = self.readConfigFile(self.currentConfig)
		if s != None:
			self.ssid = s
			self.password = p
	
	def readConfigFile(self, filename):
		with open(filename, 'rb') as csvfile:
			lines = csv.reader(csvfile, delimiter=',')
			lines = filter(None, lines)
			l = lines[0]
			if l != None and l != "":
				return l[0], l[1]
			else:
				return None
			
	def writeConfigFile(self, filename, ssid, password):
		with open(filename, 'wb') as csvfile:
			lines = csv.writer(csvfile, delimiter=',')
			lines.writerow([ssid, password])
	
	def connect(self):
		os.system("./wpa.sh " + self.ssid + " " + self.password + " &")
		sleep(1)
	
	def disconnect(self):
		os.system("./wpa.sh &")
		sleep(1)
		
	def isConnecting(self):
		return not os.path.isfile(self.currentIP)
		
	def isConnected(self):
		if not self.isConnecting():
			f = open(self.currentIP, 'rb')
			l = f.read()
			f.close()
			self.ip=l
			if l == '' or l == None:
				self.disconnect()
				return False
			return True
		return False
		
	def getIp(self):
		return self.ip

#w=Wifi() 
#print(w.ssid)
#print(w.password)

##w.disconnect()
#w.connect()

#while w.isConnecting():
	#print("Waiting")
	#sleep(0.5)

#print('connected')
#print(w.isConnected())

#print('ip')
#print(w.getIp())
