from ftplib import FTP
import filecmp
import os

class Logs():

	serverFtp = 'logs.beamian.com'
	userFtp = 'logs@beamian.com'
	passwordFtp = "KG^Hn5B0RqBq+?I=F}"
	
	currentLogFile = 'data/log.csv'
	serverPath = 'logs/'
	
	def __init__(self, deviceId):
		#Create file in server with format eg B2001.txt
		self.deviceId = deviceId
		
		self.numberLogs = 0
		
		if os.path.isfile(self.currentLogFile):
			self.numberLogs = sum(1 for line in open(self.currentLogFile))
		
		print('Logs in file: ' + str(self.numberLogs))
		
	
	def numberLogsInFile(self):
		return self.numberLogs
	
	def sendLog(self):
		
		if not os.path.isfile(self.currentLogFile):
			return True, 'No log file to upload'
		
		local_path  = self.currentLogFile
		try:
			
			ftp = FTP(self.serverFtp)
			ftp.login(self.userFtp, self.passwordFtp)
			
			ftpFiles = ftp.nlst(self.serverPath)
			
			fileName  = self.deviceId + '.csv'
			for i in range (0, 999):
				if fileName in ftpFiles:
					fileName = self.deviceId + "_" + str(i).zfill(3) + '.csv'
					continue
				else:
					break
			
			if i > 999:
				return False, 'Old log files in server'
			
			server_path = self.serverPath + fileName
			
			print('File Name Server' + fileName)
				
				
			f = open(local_path, 'rb')
			ftp.storbinary('STOR ' + server_path, f)
			f.close()
			
			ftp.quit()
			
			return self.checkLog(server_path)
		
		except Exception, e:
			errorMsg = str(e)
			return False, errorMsg[errorMsg.find("]") + 1:]
		
	def checkLog(self, server_path):
		local_path  = '/tmp/beamian_log'
		
		try:
			ftp = FTP(self.serverFtp)
			ftp.login(self.userFtp, self.passwordFtp)
					
			f = open(local_path, 'wb')
			ftp.retrbinary('RETR ' + server_path, f.write)
			f.close()
			
			ftp.quit()
			
			if filecmp.cmp(local_path,self.currentLogFile):
				os.remove(self.currentLogFile)
				self.numberLogs = 0
				return True, 'Log file uploaded with success'
			
			return False, 'Local log file do not match with server'
		
		except Exception, e:
			errorMsg = str(e)
			return False, errorMsg[errorMsg.find("]") + 1:]
		
			
	def writeLine(self, row):
		
		#CSV format
		with open(self.currentLogFile,'a') as f:
			f.write(row + '\n')



