from pirc522 import RFID
import array
import binascii
from operator import xor
import csv
from datetime import datetime
		
FAVORITE_FILE = "data/favorite-cards.csv"
LOG_FILE      = "data/log.csv"

###################################################################################
#                TAG
###################################################################################

class TagsReader():

	def __init__(self, deviceId):
		#                bus, dev,   speed, rst, ce, IOR
		self.rfid = RFID(  0,   0, 1000000,  15,  0,  29)
		self.util = self.rfid.util()
		self.util.debug = True
		self.deviceId = deviceId
		
		#Favorite Cards
		self.favorites = []
		self.waitingFavorite = False;
		
		try:
			#import tags list
			with open(FAVORITE_FILE, 'r') as csvfile:
				lines = csv.reader(csvfile, delimiter=',')
				lines = filter(None, lines)
				for l in lines:
					if l != None and l[1] != None and l[1] != '':
						self.favorites.append(l[1].lower())
			
			self.favorites.sort()
		except Exception, e:
			print('Error loading favorite csv: ' + str(e))
			
		#print(self.favorites)
		
	def wait(self):
		self.rfid.wait_for_tag()
		(error, data) = self.rfid.request()
		if not error:
			(error, uid) = self.rfid.anticoll()
			if not error:
				return uid
			
		return None
		
	def close(self):
		self.cleanup()

	def waitAndSort(self):
		
		try:
			uid = None

			#wait for new tag
			uid = None
			while uid == None:
				uid = self.wait()
			
			e0=True
			e1=True
			e2=True
			#e3=True
			
			(e0, d0) = self.rfid.read(0)
			(e1, d1) = self.rfid.read(4)
			(e2, d2) = self.rfid.read(8)
			#(e3, d3) = self.rfid.read(12)

			#needs to read the payload
			#if (e0 or e1 or e2 or e3) or (d0 == None or d1 == None or d2 == None or d3 == None  ):
			if (e0 or e1 or e2) or (d0 == None or d1 == None or d2 == None ):
				return None, ''

			data = []
			data.extend(d0)
			data.extend(d1)
			data.extend(d2)
			#data.extend(d3)
			
			#parsing
			tagId  = data[0:3]; tagId.extend(data[4:8])
			tagId  = binascii.hexlify(bytearray(tagId)).lower()
			
			#print(tagId)
			#fazer operacoes com o tag ID para confirmar
			
			if xor(xor(xor(data[0], data[1]), data[2]), 0x88) != data[3] or xor(xor(xor(data[4], data[5]), data[6]), data[7]) != data[8]:
				#Not a NTAG
				#return 1, 'Invalid TAG. Please use NTAGs'
				return self.logTag(binascii.hexlify(bytearray(uid)).lower())
			
			
			#TAG215 TAG216		
			if data[16] == 0x03:
				nBytes = data[17]
				tagPayload = data[18:18+nBytes]
				if (18+nBytes)>=48 or data[18+nBytes] != 0xfe:
					return self.logTag(tagId)
					#return 4, 'Invalid TAG. Please use NTAGs'
			
			#TAG213
			else:
				nBytes = data[22]
				tagPayload = data[23:23+nBytes]
				if (23+nBytes)>=48 or data[23+nBytes] != 0xfe:
					return self.logTag(tagId)
					#return 4, 'Invalid TAG. Please use NTAGs'
						
			#print ''.join('{:02x}'.format(x) for x in tagPayload)
			
			#print(nBytes)
			#is a blank TAG?
			if nBytes == 0:
				return self.logTag(tagId)
			
			#Basic UTF8?
			if tagPayload[0] == 0xd1 and tagPayload[1] == 0x01 and tagPayload[3] == 0x54:
				utfPayload = tagPayload[7:nBytes]
				utfPayload = array.array('b', utfPayload).tostring().decode('utf-8')
				(r, m) = self.decodePayload(utfPayload)
				if(r == None):
					return self.logTag(tagId)
				return r, m
			
			print('Invalid payload')
			return -1, 'Invalid payload'

		except Exception, e:
			print str(e)
			return None, ''
		
	def decodePayload(self, s):

		if s.lower() == "turnoff":
			return 1, 'Turn Off'
		
		if s.lower() == "update":
			return 2, 'Update Firmware'

		if s.lower() == "upload":
			return 3, 'Upload Log File'
		
		if s.lower()[:4] == "idb2":
			print('new id tag')
			return 4, s[2:].upper()

		if s.lower()[:5] == "vidb2":
			print('new virtual id tag')
			return 7, s[3:].upper()

		print 'Unknown payload'
		
		return None, 'Unknown payload'

	def logTag(self, tagId):
		
		if tagId == None or tagId == '':
			return None, ''
		
		dateStr = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
		
		if tagId in self.favorites:
			if self.waitingFavorite:
				self.waitingFavorite = False
				return 6, ''
			
			else:
				print('waitingFavorite')
				self.waitingFavorite = True
				return 5, 'Favorite'
		
		else:
			if self.waitingFavorite:
				cardType = 'Favorite'
				self.waitingFavorite = False
			else:
				cardType = 'Standard'
		
		#CSV format
		row = [tagId.upper(), dateStr, self.deviceId, cardType]
		
		with open(LOG_FILE,'a') as f:
			w = csv.writer(f)
			w.writerow(row)
				
		print("Tag saved: " + str(tagId))

		return 0, ''
	
