#!/usr/bin/python

from time import sleep
import os

from interface    import Interface
from tagsReader   import TagsReader		
from update       import Update
from wifi         import Wifi
from sendLog      import SendLog


gui = []
up  = []
wifi= []
tr  = []
sl  = []

###################################################################################
#                MAIN
###################################################################################
# NAME        : main
# DESCRIPTION : Open a socket and process the received data
#
# INPUTS      : 
#
# OUTPUTS     :
################################################################################### 
def main():
	global gui, up, wifi, tr, sl
	
	print('Version0011 - Release Version for virtual ID')

	
	gui = Interface()
	
	
	##read configuration and updates
	up = Update()
	tr = TagsReader(up.getVirtualId())
	sl = SendLog(up.getId())	
	wifi = Wifi()
	

	gui.setId(up.getVirtualId())
	
	gui.setLogo('data/logo.png')
	gui.setWifi(False)
	gui.setBluetooth(False)
	gui.setBeep(True)
	
	if firstRun():
		gui.setBeepFreq(4200)
		gui.makeBeep()
		sleep(0.1)
		gui.setBeepFreq(6000)	
		gui.makeBeep()

		gui.setPopup("Checking new image")
		sleep(1)
		gui.updateScreenID()
		sleep(1)
		gui.updateScreen()
		firstRunSuccess()
		gui.stop()
		exitRestartApp()
	
	
	
	print('ID: ' + up.getId() + ' MAC: ' + up.getMac())
	gui.setPopup('ID:\n' + up.getVirtualId() + '\n\nMAC:\n' + up.getMac()[0:8] + '\n' + up.getMac()[9:17])
	
	gui.setBeepFreq(6000)
	gui.makeBeep()
	gui.setBeepFreq(4200)	
	gui.makeBeep()
	sleep(2.5)
	gui.updateScreen()
	
	while True:
		
		code, msg = tr.waitAndSort()
		if code == None:
			continue
		gui.makeBeep() 


		# code 0 = tag ok
		if code == 0:
			gui.setCounts(gui.getCounts() + 1)
		
		# code -1 = Error in TAG
		if code == -1:
			print(msg)
			#gui.popup(m)
		
		# code 1 = exitShutdown
		if code == 1: break
		
		# code 2 = Update
		if code == 2: update()
		
		# code 3 = Upload
		if code == 3: upload()
		
		# code 4 = Change id
		if code == 4: changeId(msg)
		
		# code 5 = Favorit
		if code == 5:
			gui.setPopup(msg)
		
		# code 6 = Exit Favorite
		if code == 6:
			gui.updateScreen()
			
		# code 7 = Virtual ID
		if code == 7: changeVirtualId(msg)
			
		sleep(0.5)
		
	gui.stop()
	exitShutdown()

def connectWifi():
	#Try connect
	if not wifi.isConnected():
		wifi.connect()
		while wifi.isConnecting():
			gui.setWifi(True, 2)
			sleep(0.5)
			gui.setWifi(True, 3)
			sleep(0.5)
			gui.setWifi(True, 4)
			sleep(0.5)
	
	#No connection
	if not wifi.isConnected():
		print(       'Cannot connect to wireless network')
		gui.setPopup('Cannot connect to wireless network')
		sleep(2)
		gui.setWifi(True, -1)
		return False
	
	print(       'Ip Address: ' + wifi.getIp())
	gui.setPopup('Ip Address: ' + wifi.getIp())
	sleep(2)
	return True
	

def update():
	global wifi, gui
	
	print ('Update')
	if connectWifi():
		print(       'Checking for updates')
		gui.setPopup('Checking for updates')
		sleep(1)
		version, data, msg = up.checkUpdates()
		gui.setPopup(msg)

		if data !=  None:
			print msg
			v, m = up.updateData()
			gui.setPopup(m + '\n\n' + data)
			sleep(1)
			
		if version !=  None:
			print msg
			v, m = up.updateFirmware()	
			gui.setPopup(m + '\n\n' + version)
			sleep(1)
		
			#valid image downloaded
			if v:
				gui.stop()
				exitUpdate()
				
		if version ==  None and data ==  None:
			sleep(1)	
			
		gui.updateScreen()
	
def upload():
	global gui, wifi, sl
	
	print ('Update')
	if connectWifi():
		print(       'Uploading log file')
		gui.setPopup('Uploading log file')
		sleep(1)
		
		r, m = sl.sendLog()
		
		print(m)
		gui.setPopup(m)
		sleep(2)
	
	gui.updateScreen()

def changeId(msg):
	global gui, up
	up.newId(msg)
	
	print(       'New ID: \n' + msg)
	gui.setPopup('New ID: \n' + msg)
	sleep(2)
	gui.updateScreen()
	
	gui.stop()
	exitRestart()

def changeVirtualId(msg):
	global gui, up
	up.setVirtualId(msg)
	print(       'New virtual ID:\n' + msg)
	gui.setPopup('New virtual ID:\n' + msg, 2)
	gui.stop()
	exitRestartApp()		
	
####################################
#        Exit codes
####################################
def exitRestart():
	exit(1)

def exitShutdown():
	exit(2)

def exitUpdate():
	exit(3)

def exitRestartApp():
	exit(4)
	

####################################
#      Check first time
####################################
def firstRun():
	#verify if file exist
	return not (os.path.isfile('.loaded.txt'))

def firstRunSuccess():
	#create loaded file
	return open('.loaded.txt', 'w+').close()
	
if __name__ == "__main__":
	main()
