import pygame
import os
import subprocess
import pigpio
from threading import Timer,Thread,Event
from time import sleep
from signal import alarm, signal, SIGALRM, SIGKILL

# Overlays path
overlays_path = os.path.dirname(os.path.realpath(__file__)) + '/overlays/'
notifications_color = (210, 210, 210)

# Screen visible width, height anf offset
screen_width     = 126
screen_height    = 158
screen_start_pos = (1,1)
notifications_height = 30

# LCD dimensions
lcd_width     = 128
lcd_height    = 160


# set up the colors
BLACK = (  0,   0,   0)
WHITE = (255, 255, 255)
RED   = (255,   0,   0)
GREEN = (  0, 255,   0)
BLUE  = (  0,   0, 255)
POPUP = ( 59, 230, 240)


############################################
# Interface Commands
############################################
WIFI_ENABLE = 1
WIFI_STATUS = 2
BT_ENABLE   = 3
BT_STATUS   = 4
LOGO        = 5
COUNTS      = 6
ID          = 7
ID_TIME     = 8
BEEP_ENABLE = 9
BEEP_FREQ   = 10
MAKE_BEEP   = 11
POPUP_TEXT  = 12
DISPLAY_POPUP= 13

############################################
# Internal status interface 
############################################
_status = {}
_status[WIFI_ENABLE] = False
_status[WIFI_STATUS] = -1
_status[BT_ENABLE  ] = False
_status[BT_STATUS  ] = -1
_status[LOGO       ] = overlays_path + 'logo.png'
_status[COUNTS     ] = 0
_status[ID         ] = "ID"
_status[ID_TIME    ] = 30
_status[BEEP_ENABLE] = True
_status[BEEP_FREQ  ] = 4200
_status[POPUP_TEXT ] = ""


class Interface():
			
	class updateTimer():	
		def __init__(self,t1, hFunction1,t2, hFunction2):
			self.t1=t1
			self.hFunction1 = hFunction1
			self.t2=t2
			self.hFunction2 = hFunction2
			self.thread= Timer(self.t1,self.handle_function1)

		def handle_function1(self):
			self.hFunction1()
			self.thread = Timer(self.t2,self.handle_function2)
			self.thread.start()

		def handle_function2(self):
			self.hFunction2()
			self.thread = Timer(self.t1,self.handle_function1)
			self.thread.start()

		def start(self):
			self.thread.start()

		def cancel(self):
			self.thread.cancel() 

	class lcdInterface():
		def __init__(self):	
			
		
			drivers = ['fbcon', 'directfb', 'svgalib']
			found = False
			for driver in drivers:
				# Make sure that SDL_VIDEODRIVER is set
				if not os.getenv('SDL_VIDEODRIVER'):
					os.putenv('SDL_VIDEODRIVER', driver)
					os.putenv('SDL_FBDEV', '/dev/fb1')
				try:
					pygame.display.init()
				except pygame.error:
					print 'Driver: {0} failed.'.format(driver)
					continue
				found = True
				break
		
			if not found:
				raise Exception('No suitable video driver found!')
			
			
			
			#pygame.init()
			#pygame.mouse.set_visible(False)
			
						# this section is an unbelievable nasty hack - for some reason Pygame
			# needs a keyboardinterrupt to initialise in some limited circs (second time running)
			class Alarm(Exception):
				pass
			def alarm_handler(signum, frame):
				raise Alarm
			signal(SIGALRM, alarm_handler)
			alarm(3)
			
			try:
				pygame.init()
				pygame.mouse.set_visible(False)
				self.lcd = pygame.display.set_mode((lcd_width, lcd_height), pygame.FULLSCREEN| pygame.DOUBLEBUF | pygame.HWSURFACE)
				alarm(0)
			except Alarm:
				raise KeyboardInterrupt
			
			#self.lcd = pygame.display.set_mode((lcd_width, lcd_height), pygame.FULLSCREEN| pygame.DOUBLEBUF | pygame.HWSURFACE)
			#bootImg=pygame.image.load('/etc/splash.png')
			#self.lcd.blit(bootImg,(0,0))
			#pygame.display.update()
			
			self.lcd.fill(WHITE)
			#pygame.display.update()

			# Start fonts
			pygame.font.init()

			#Create a visible windows (screen)
			self.screen = pygame.surface.Surface((screen_width, screen_height))
			self.screen.fill(WHITE)

			self.popup = pygame.surface.Surface((screen_width-20, screen_height-notifications_height-20))
			self.popup.fill(WHITE)
			
			notifications_fill = pygame.surface.Surface((lcd_width, notifications_height + (lcd_height-screen_height)))
			notifications_fill.fill(notifications_color)
			self.lcd.blit(notifications_fill, (0, screen_height - notifications_height + screen_start_pos[1]))

			#Create 'Notification Bar' and 'Logo' areas
			self.notifications = pygame.surface.Surface((screen_width, notifications_height))
			self.logo = pygame.surface.Surface((screen_width, screen_height - notifications_height - 4))
			
			self.updateScreen('0')
		
		def stop(self):
			pygame.quit()
			
		######################################
		def updateLogo(self, surface, path ):
			#load image
			image = pygame.image.load(path).convert_alpha()
			
			#scale image
			scale_x = 1.0*surface.get_width()/image.get_width()
			scale_y = 1.0*surface.get_height()/image.get_height()
			if(scale_x < scale_y): scale = scale_x
			else                 : scale = scale_y
			image = pygame.transform.smoothscale(image, (int(image.get_width()*scale), int(image.get_height()*scale)))
			
			#center horizontally and vertically
			x=0
			y=0
			x = (surface.get_width()-image.get_width())/2
			y = (surface.get_height()-image.get_height())/2

			surface.blit(image, (x,y))
			return
			
		def updateNotifications(self, surface, path, wifi_visibility, wifi, bt_visibility, bt, message = ''):
			
			x_offset = 2;
			#update text and align to right
			myfont = pygame.font.SysFont('Arial', 18)
			text = myfont.render(message, True, BLACK)
			text_rect = text.get_rect()
			text_rect.right = surface.get_width()
			surface.blit(text, (text_rect.x - 2, ((surface.get_height()-text_rect.height)/2 + 1) ) )
			
			#load wifi icons if enabled (Left aligned)
			if(wifi_visibility):
				if(wifi >= 0 and wifi <= 4):
					wifi_icon = pygame.image.load(path + 'wifiSignal' + str(wifi) + '.png').convert_alpha()
				else:
					wifi_icon = pygame.image.load(path + 'wifiNoInterface.png').convert_alpha()

				surface.blit(wifi_icon, (x_offset,1))
				x_offset = x_offset + 28 - 2

			#load bluetooth icons if enabled (Left aligned)	
			if(bt_visibility):
				if(bt == 0):
					bt_icon = pygame.image.load(path + 'bluetooth.png').convert_alpha()
				elif(bt == 1):
					bt_icon = pygame.image.load(path + 'bluetoothConnect.png').convert_alpha()
				else:
					bt_icon = pygame.image.load(path + 'bluetoothNoInterface.png').convert_alpha()
				
				surface.blit(bt_icon, (x_offset,1))	
				x_offset = x_offset + 28 - 2
								
			return

		def updateScreen(self, s):	
			global _status
			self.logo.fill(WHITE)
			
			try:
				self.updateLogo(self.logo, _status[LOGO])
			except Exception, e:
				self.updateLogo(self.logo, overlays_path + 'logo.png')
			
			self.notifications.fill(notifications_color)
			self.updateNotifications(self.notifications, overlays_path, _status[WIFI_ENABLE], _status[WIFI_STATUS], _status[BT_ENABLE], _status[BT_STATUS], s)
			
			self.screen.blit(self.logo,(  0,  0))
			self.screen.blit(self.notifications,(  0, screen_height - notifications_height))

			self.lcd.blit(self.screen, screen_start_pos)
			pygame.display.update()
		
		def popUp(self, s):		
			pos = (0,0)
			self.popup.fill(POPUP)
			font = pygame.font.SysFont('Arial', 19)
			color=pygame.Color('black')
			
			words = [word.split(' ') for word in s.splitlines()]  # 2D array where each row is a list of words.
			space = font.size(' ')[0]  # The width of a space.
			max_width, max_height = self.popup.get_size()
			textSurface = pygame.surface.Surface((max_width, max_height))
			textSurface.fill(POPUP)
			max_x=0
			x, y = pos
			for line in words:
				for word in line:
					word_surface = font.render(word, 0, color)
					word_width, word_height = word_surface.get_size()
					if x + word_width >= max_width:
						x = pos[0]  # Reset the x.
						y += word_height  # Start on new row.
					textSurface.blit(word_surface, (x, y))
					x += word_width + space
					if x > max_x: max_x=x
				x =pos[0]  # Reset the x.
				y += word_height  # Start on new row.
			
			self.popup.blit(textSurface, ((max_width-max_x)/2, (max_height-y)/2))
			
			self.lcd.blit(self.popup, (screen_start_pos[0]+10, screen_start_pos[1]+10) )
			
			pygame.display.update()		

	class beepInterface():
		def __init__(self):
			#subprocess.call('pigpiod', shell=True)
			#create crontab
			self.pg = pigpio.pi()
			self.setFreq()
			
		def setFreq(self):
			global _status
			self.pg.set_PWM_frequency(17, _status[BEEP_FREQ])
			self.pg.set_PWM_dutycycle(17, 0)
			
		def beep(self):
			global _status
			if _status[BEEP_ENABLE]:
				self.setFreq()
				self.pg.set_PWM_dutycycle(17, 127)
				sleep(0.1)
			self.pg.set_PWM_dutycycle(17, 0)

	###################################################################################
	#                INTERFACE
	###################################################################################
	def __init__(self):
		global _status
		self.lcd_interface = self.lcdInterface()
		self.beep_interface = self.beepInterface()
		self.threadInterface = self.updateTimer(_status[ID_TIME], self.updateScreenID, 1, self.updateScreenCount)
		self.threadInterface.start()
	
	def stop(self):
		self.lcd_interface.stop()
		self.threadInterface.cancel()
	
	def updateScreen(self):
		self.updateScreenCount()
		
	def updateScreenCount(self):
		global _status
		self.lcd_interface.updateScreen(str(_status[COUNTS]))

	def updateScreenID(self):
		global _status
		self.lcd_interface.updateScreen(str(_status[ID]))

	def updateScreenPopUp(self):
		global _status
		self.lcd_interface.popUp(str(_status[POPUP_TEXT]))
		
	############################################
	# WIFI_ENABLE, WIFI_STATUS
	############################################
	def setWifi(self, enable=False, status=-1):
		global _status
		_status[WIFI_ENABLE] = enable
		_status[WIFI_STATUS] = status
		self.updateScreenCount()
	
	def getWifiStatus(self):
		global _status
		return _status[WIFI_STATUS]
	
	def getWifiEnable(self):
		global _status
		return _status[WIFI_ENABLE]
	

	############################################
	# BT_ENABLE 
	############################################
	def setBluetooth(self, enable=False, status=-1):
		global _status
		_status[WIFI_ENABLE] = enable
		_status[WIFI_STATUS] = status
		self.updateScreenCount()
	
	def getBluetoothStatus(self):
		global _status
		return _status[BT_STATUS]
	
	def getBluetoothEnable(self):
		global _status
		return _status[BT_ENABLE]

	############################################
	# LOGO 
	############################################
	def setLogo(self, s=""):
		global _status
		_status[LOGO] = s
		self.updateScreenCount()
	
	def getBluetoothStatus(self):
		return _status[LOGO]

	############################################
	# COUNTS 
	############################################
	def setCounts(self, c=0):
		global _status
		_status[COUNTS] = c
		self.updateScreenCount()
	
	def getCounts(self):
		global _status
		return _status[COUNTS]

	############################################
	# ID 
	############################################
	def setId(self, s=""):
		global _status
		_status[ID] = s
		self.updateScreenCount()
	
	def getId(self):
		return _status[ID]
		
	############################################
	# ID_TIME 
	############################################
	def setIdTime(self, c=0):
		global _status
		_status[ID_TIME] = c
		self.updateScreenCount()
	
	def getIdTime(self):
		global _status
		return _status[ID_TIME]

	############################################
	# BEEP_ENABLE 
	############################################
	def setBeep(self, b=False):
		global _status
		_status[BEEP_ENABLE] = b
	
	def getBeep(self):
		global _status
		return _status[BEEP_ENABLE]

	############################################
	# BEEP_FREQ
	############################################
	def setBeepFreq(self, c=4200):
		global _status
		_status[BEEP_FREQ] = c
	
	def getBeepFreq(self):
		global _status
		return _status[BEEP_FREQ]

	############################################
	# MAKE_BEEP 
	############################################
	def makeBeep(self):
		self.beep_interface.beep()

	############################################
	# POPUP_TEXT
	############################################
	def setPopup(self, s="", t=0):
		global _status
		_status[POPUP_TEXT] = s
		self.updateScreenPopUp()
		if t>0:
			sleep(t)
			self.updateScreenCount()
		

	#functions

	#gui.setWifi(True, 1)
	#gui.getWifiStatus()
	#gui.getWifiEnable()
	#gui.setBluetooth( True, 1)
	#gui.getBluetoothStatus()
	#gui.getBluetoothEnable()
	#gui.setLogo("a")
	#gui.getBluetoothStatus()
	#gui.setCounts(0)
	#gui.getCounts()
	#gui.setId("ID: 0000")
	#gui.getId()
	#gui.setIdTime(1)
	#gui.getIdTime()
	#gui.setCounts(False)
	#gui.getCounts()
	#gui.setBeepFreq(4200)
	#gui.getBeepFreq()
	#gui.makeBeep()
	#gui.setPopup("PopUp")
