#!/usr/bin/python

from time import sleep
import os

from interface    import Interface
from tagsReader   import TagsReader		
from update       import Update
from wifi         import Wifi

#Exit codes
def exitRestart():
	exit(1)

def exitShutdown():
	exit(2)

def exitUpdate():
	exit(3)

def exitRestartApp():
	exit(4)

def firstRun():
	#verify if file exist
	return not (os.path.isfile('.loaded.txt'))

def firstRunSuccess():
	#create loaded file
	return open('.loaded.txt', 'w+').close()
	
###################################################################################
#                MAIN
###################################################################################
# NAME        : main
# DESCRIPTION : Open a socket and process the received data
#
# INPUTS      : 
#
# OUTPUTS     :
################################################################################### 
def main():
	
	print('Version0002 - no beep')

	##read configuration and updates
	up = Update()
	##up.test ping with server??

	gui = Interface()
	gui.setId('ID ' + up.getId())
	gui.setLogo('data/logo.png')
	gui.setWifi(False)
	gui.setBluetooth(False)
	
	gui.setBeep(False)
	oldFreq = gui.getBeepFreq()
	gui.setBeepFreq(2100)
	gui.makeBeep()
	gui.setBeepFreq(oldFreq)	
	
	print("RFID Started")
	tr = TagsReader()
	
	wifi = Wifi()
	
	if firstRun():
		gui.setPopup("Checking new image")
		sleep(1)
		gui.updateScreenID()
		sleep(1)
		gui.updateScreen()
		firstRunSuccess()
		gui.stop()
		exitRestartApp()
	
	
	while True:
		
		tagId = tr.wait()
		if tagId == None: continue
		gui.makeBeep()
		gui.setCounts(gui.getCounts() + 1)
		if gui.getCounts() == 10:
						
			#Try connect
			if not wifi.isConnected():
				wifi.connect()
				while wifi.isConnecting():
					gui.setWifi(True, 2)
					sleep(0.5)
					gui.setWifi(True, 3)
					sleep(0.5)
					gui.setWifi(True, 4)
					sleep(0.5)
			
			#No connection
			if not wifi.isConnected():
				gui.setPopup('Cannot connect to wireless network')
				sleep(2)
				gui.setWifi(True, -1)
				continue
			
			gui.setPopup('Ip Address: ' + wifi.getIp() + '\nChecking for updates')
			sleep(1)
			version, data, msg = up.checkUpdates()
			gui.setPopup(msg)
			if data !=  None:
				print msg
				v, m = up.updateData()
				gui.setPopup(m)
				sleep(1)
				
				
			if version !=  None:
				print msg
				v, m = up.updateFirmware()	
				gui.setPopup(m)
				sleep(1)
			
				#valid image downloaded
				if v:
					gui.stop()
					exitUpdate()
					
			if version ==  None and data ==  None:
				sleep(1)
		
			gui.updateScreen()
			continue
		
		if gui.getCounts() == 20:
			break
			
		print("New Tag: " + str(tagId))
		sleep(0.2)
	
	gui.stop()
	exitShutdown()
	
if __name__ == "__main__":
	main()
