from pirc522 import RFID

###################################################################################
#                TAG
###################################################################################

class TagsReader():

	def __init__(self):
		#                bus, dev,   speed, rst, ce, IOR
		self.rfid = RFID(  0,   0, 1000000,  15,  0,  29)

	def wait(self):
		self.rfid.wait_for_tag()
		(error, data) = self.rfid.request()
		if not error:
			(error, uid) = self.rfid.anticoll()
			if not error:
				return uid
			
		return None
		
	def close(self):
		self.cleanup()
