from uuid import getnode as get_mac
import requests


class LiveInteraction:
    @staticmethod
    def get_mac_address():
        # get mac address and format it to something like AA:BB:CC::DD:EE
        return ':'.join((hex(get_mac()))[i:i+2] for i in range(2, 14, 2))

    def __init__(self, domain):
        self.domain = domain
        self.endpoint = 'api/live-interactions'
        self.mac_address = LiveInteraction.get_mac_address()

    @property
    def url(self):
        return self.domain + self.endpoint

    def create(self, tag_id):
        data = {
            'mac_address': self.mac_address,
            'tag_id': tag_id
        }

        response = requests.post(self.url, json=data)

        if response.status_code == 201:
            # valid post - created new interaction
            return True
        if response.status_code == 200:
            # valid post - update interaction timestap
            return True

        return False

